import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/components/custom_clock/custom_clock.dart';
import 'package:admin_desktop/presentation/routes/app_router.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/presentation/theme/theme/theme_wrapper.dart';
import 'package:auto_route/auto_route.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:admin_desktop/application/providers.dart';
import 'notifications/components/notification_count_container.dart';
import 'notifications/notification_dialog.dart';
import 'language/languages_modal.dart';
import 'menu/menu_modal.dart';

class MainAppbar extends ConsumerWidget {
  const MainAppbar({super.key});

  @override
  Widget build(BuildContext context, ref) {
    final customerNotifier = ref.read(customerProvider.notifier);
    final notifier = ref.read(mainProvider.notifier);
    final user = LocalStorage.getUser();
    return Container(
      color: Style.white,
      child: IntrinsicHeight(
        child: ThemeWrapper(
          builder: (colors, controller) {
            return Row(
              children: [
                30.horizontalSpace,
                Expanded(
                  child: Row(
                    children: [
                      const Icon(
                        Remix.search_2_line,
                        size: 20,
                        color: Style.black,
                      ),
                      17.horizontalSpace,
                      Expanded(
                        flex: 2,
                        child: TextFormField(
                          onChanged: (value) {
                            if (user?.role == TrKeys.seller) {
                              ref.watch(mainProvider).selectIndex == 3
                                  ? customerNotifier.searchUsers(
                                      context, value.trim())
                                  : notifier.setProductsQuery(
                                      context, value.trim());
                              if (ref.watch(mainProvider).selectIndex == 6) {
                                if (ref.watch(profileProvider).selectIndex ==
                                    4) {
                                  ref
                                      .read(addressProvider.notifier)
                                      .searchCountry(
                                          context: context,
                                          search: value.trim());
                                } else if (ref
                                        .watch(profileProvider)
                                        .selectIndex ==
                                    5) {
                                  ref.read(addressProvider.notifier).searchCity(
                                      context: context,
                                      search: value.trim(),
                                      countyId:
                                          ref.watch(addressProvider).countryId);
                                }
                              }
                            }
                          },
                          cursorColor: Style.black,
                          cursorWidth: 1.r,
                          decoration: InputDecoration.collapsed(
                            hintText: AppHelpers.getTranslation(ref
                                        .watch(mainProvider)
                                        .selectIndex ==
                                    1
                                ? TrKeys.searchOrders
                                : ref.watch(mainProvider).selectIndex == 2
                                    ? ref.watch(productProvider).stateIndex == 0
                                        ? TrKeys.searchProducts
                                        : ref
                                                    .watch(productProvider)
                                                    .stateIndex ==
                                                3
                                            ? TrKeys.searchBrands
                                            : TrKeys.searchCategory
                                    : ref.watch(mainProvider).selectIndex == 3
                                        ? AppHelpers.getTranslation(
                                            TrKeys.searchComments)
                                        : ref.watch(mainProvider).selectIndex ==
                                                6
                                            ? ref
                                                        .watch(profileProvider)
                                                        .selectIndex ==
                                                    4
                                                ? TrKeys.searchCountry
                                                : ref
                                                            .watch(
                                                                profileProvider)
                                                            .selectIndex ==
                                                        5
                                                    ? TrKeys.searchCity
                                                    : AppHelpers.getTranslation(
                                                        TrKeys.searchLocation)
                                            : TrKeys.search),
                            hintStyle: Style.interNormal(
                              size: 18,
                              color: Style.searchHint.withOpacity(0.3),
                              letterSpacing: -14 * 0.02,
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
                const VerticalDivider(),
                SizedBox(width: 120.w, child: const CustomClock()),
                const VerticalDivider(),
                IconButton(
                  onPressed: () async {
                    // Navigator.of(context)
                    //     .push(MaterialPageRoute(
                    //   builder: (context) =>
                    //       const WebViewPage(
                    //           url:
                    //               "${AppConstants.webUrl}/help"),
                    // ));
                    context.pushRoute(const HelpRoute());
                  },
                  icon: const Icon(
                    Remix.question_line,
                    color: Style.black,
                  ),
                ),
                Stack(
                  children: [
                    Padding(
                      padding: const EdgeInsets.only(right: 16),
                      child: IconButton(
                          onPressed: () {
                            showDialog(
                                context: context,
                                builder: (_) => const Row(
                                      mainAxisAlignment: MainAxisAlignment.end,
                                      children: [
                                        Dialog(child: NotificationDialog()),
                                      ],
                                    ));
                          },
                          icon: const Icon(
                            Remix.notification_2_line,
                            color: Style.black,
                          )),
                    ),
                    Positioned(
                      right: 0,
                      top: 0,
                      child: NotificationCountsContainer(
                          count: ref
                              .watch(notificationProvider)
                              .countOfNotifications
                              ?.notification),
                    ),
                  ],
                ),
                IconButton(
                  onPressed: () {
                    ref.read(languagesProvider.notifier).getLanguages(context);
                    showDialog(
                        context: context,
                        builder: (_) {
                          return Row(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.end,
                            children: [
                              Dialog(
                                alignment: Alignment.topRight,
                                child: SizedBox(
                                  height: MediaQuery.sizeOf(context).height / 2,
                                  width: MediaQuery.sizeOf(context).width / 4,
                                  child: Column(
                                    children: [
                                      Padding(
                                        padding: REdgeInsets.only(
                                            left: 15, right: 15, top: 15),
                                        child: Row(
                                          children: [
                                            Text(
                                              AppHelpers.getTranslation(
                                                  TrKeys.language),
                                              style: Style.interMedium(
                                                size: 22,
                                              ),
                                            ),
                                            const Spacer(),
                                            IconButton(
                                                onPressed: () {
                                                  Navigator.pop(context);
                                                },
                                                icon: const Icon(
                                                    Remix.close_fill))
                                          ],
                                        ),
                                      ),
                                      Expanded(
                                        child: LanguagesModal(
                                          afterUpdate: () {
                                            controller.toggle();
                                            controller.toggle();
                                          },
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ],
                          );
                        });
                  },
                  icon: const Icon(
                    Remix.global_line,
                    color: Style.black,
                  ),
                ),
                InkWell(
                  onTap: () {
                    ref.read(mainProvider.notifier).changeIndex(
                        AppHelpers.getUserRole == TrKeys.master ? 2 : 8);
                  },
                  child: Container(
                    decoration: BoxDecoration(
                        border: Border.all(
                          color: ref.watch(mainProvider).selectIndex == 7
                              ? Style.primary
                              : Style.textColor,
                        ),
                        borderRadius: BorderRadius.circular(20.r)),
                    child: CommonImage(
                        width: 40,
                        height: 40,
                        radius: 20,
                        url: LocalStorage.getUser()?.img ?? ""),
                  ),
                ),
                AppHelpers.getUserRole == TrKeys.master
                    ? SizedBox.shrink()
                    : IconButton(
                        onPressed: () {
                          showDialog(
                              context: context,
                              builder: (_) => Row(
                                    mainAxisAlignment: MainAxisAlignment.end,
                                    children: [
                                      Dialog(
                                        child: SizedBox(
                                          height: MediaQuery.sizeOf(context)
                                                  .height /
                                              1.2,
                                          width:
                                              MediaQuery.sizeOf(context).width /
                                                  4,
                                          child: Column(
                                            children: [
                                              Padding(
                                                padding: REdgeInsets.only(
                                                    left: 15,
                                                    right: 15,
                                                    top: 15),
                                                child: Row(
                                                  children: [
                                                    Text(
                                                      AppHelpers.getTranslation(
                                                          TrKeys.menu),
                                                      style: Style.interMedium(
                                                          size: 22),
                                                    ),
                                                    const Spacer(),
                                                    IconButton(
                                                        onPressed: () {
                                                          Navigator.pop(
                                                              context);
                                                        },
                                                        icon: const Icon(
                                                            Remix.close_fill))
                                                  ],
                                                ),
                                              ),
                                              const Expanded(
                                                child: MenuModal(),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    ],
                                  ));
                        },
                        icon: const Icon(
                          Remix.menu_2_line,
                          color: Style.black,
                        ),
                      ),
                10.horizontalSpace,
              ],
            );
          },
        ),
      ),
    );
  }
}
